<?php
    defined('PF_VERSION') OR exit('Access denied');
class Pf_Aphrodite_Shortcode{
    protected $db;
    protected $homepage;
    protected $home_info;
    protected $homepage_li;

    function __construct(){
        $this->db          = Pf::database();
        $this->homepage    = get_configuration('default_page');
        $this->home_info   = $this->get_page_info($this->homepage);
        $this->homepage_li = "<li><a href='" . RELATIVE_PATH . "'>" . $this->home_info['page_title'] . "</a></li>";
    }

    public function button($atts, $content = null){
        $defaults = array(
            'class' => "btn btn-color"
        );
        $script   = '';
        if(isset($atts['data-toggle'])){
            switch(strtolower(trim($atts['data-toggle']))){
                case 'tooltip':
                    $tooltip_class = 'tooltop-' . uniqid() . rand(1, 1000);
                    if(isset($atts['class'])){
                        $atts['class'] = $atts['class'] . ' ' . $tooltip_class;
                    }else{
                        $defaults['class'] = $defaults['class'] . ' ' . $tooltip_class;
                    }
                    $script = "
                    <script>
                        $('.{$tooltip_class}').tooltip();
                    </script>
                    ";
                    break;
                case 'popover':
                    $popover_class = 'popover-' . uniqid() . rand(1, 1000);
                    if(isset($atts['class'])){
                        $atts['class'] = $atts['class'] . ' ' . $popover_class;
                    }else{
                        $defaults['class'] = $defaults['class'] . ' ' . $popover_class;
                    }
                    $script = "
            	    <script>
            	    $('.{$popover_class}').popover();
            	    </script>
            	    ";
                    break;
            }
        }
        $type = isset($atts['type']) ? $atts['type'] : 'button';
        $html = "<button type=\"" . $type . "\" " . parse_atts($atts, $defaults) . ">" . Pf::shortcode()->exec($content) . "</button>" . $script;
        return $html;
    }

    function button_group($atts, $content = null){
        $defaults = array(
            'class' => "btn-group"
        );
        $script   = '';
        if(isset($atts['data-toggle'])){
            switch(strtolower(trim($atts['data-toggle']))){
                case 'tooltip':
                    $tooltip_class = 'tooltop-' . uniqid() . rand(1, 1000);
                    if(isset($atts['class'])){
                        $atts['class'] = $atts['class'] . ' ' . $tooltip_class;
                    }else{
                        $defaults['class'] = $defaults['class'] . ' ' . $tooltip_class;
                    }
                    $script = "
            	    <script>
            	    $('.{$tooltip_class}').tooltip();
            	    </script>
            	    ";
                    break;
                case 'popover':
                    $popover_class = 'popover-' . uniqid() . rand(1, 1000);
                    if(isset($atts['class'])){
                        $atts['class'] = $atts['class'] . ' ' . $popover_class;
                    }else{
                        $defaults['class'] = $defaults['class'] . ' ' . $popover_class;
                    }
                    $script = "
        	        <script>
        	        $('.{$popover_class}').popover();
        	        </script>
        	        ";
                    break;
            }
        }

        return "<div " . parse_atts($atts, $defaults) . ">" . Pf::shortcode()->exec($content) . "</div>" . $script;;
    }

    public function icon($atts, $content = null){
        $type = 'fa';
        if(!empty($atts['type'])){
            $type = $atts['type'];
        }
        $type = strtolower($type);
        switch($type){
            case 'fa':
                $atts['name'] = (!empty($atts['name'])) ? 'fa-' . $atts['name'] : '';
                $atts['size'] = (!empty($atts['size'])) ? ' fa-' . $atts['size'] : '';
                $icon_atts    = array(
                    'class' => "fa " . $atts['name'] . $atts['size']
                );
                break;
        }
        $script = '';
        if(isset($atts['data-toggle'])){
            switch(strtolower(trim($atts['data-toggle']))){
                case 'tooltip':
                    $tooltip_class      = 'tooltop-' . uniqid() . rand(1, 1000);
                    $icon_atts['class'] = $icon_atts['class'] . ' ' . $tooltip_class;
                    $script             = "
            	    <script>
            	    $('.{$tooltip_class}').tooltip();
            	    </script>
            	    ";
                    break;
                case 'popover':
                    $popover_class      = 'popover-' . uniqid() . rand(1, 1000);
                    $icon_atts['class'] = $icon_atts['class'] . ' ' . $popover_class;
                    $script             = "
        	        <script>
        	        $('.{$popover_class}').popover();
        	        </script>
        	        ";
                    break;
            }
        }

        return "<i " . parse_atts($icon_atts) . " ></i>" . $script;
    }

    public function row($atts, $content = null){
        $atts['class'] = (!empty($atts['class'])) ? 'row ' . $atts['class'] : 'row';

        return "<div " . parse_atts($atts) . ">" . Pf::shortcode()->exec($content) . "</div>";
    }

    public function _row($atts, $content = null){
        $atts['class'] = (!empty($atts['class'])) ? 'row ' . $atts['class'] : 'row';

        return "<div " . parse_atts($atts) . ">" . Pf::shortcode()->exec($content) . "</div>";
    }

    public function col($atts, $content = null){
        $atts['class'] = (!empty($atts['class'])) ? $atts['class'] : 'col-sm-12';

        return "<div " . parse_atts($atts) . ">" . Pf::shortcode()->exec($content) . "</div>";
    }

    public function _col($atts, $content = null){
        $atts['class'] = (!empty($atts['class'])) ? $atts['class'] : 'col-sm-12';

        return "<div " . parse_atts($atts) . ">" . Pf::shortcode()->exec($content) . "</div>";
    }

    public function __col($atts, $content = null){
        $atts['class'] = (!empty($atts['class'])) ? $atts['class'] : 'col-sm-12';

        return "<div " . parse_atts($atts) . ">" . Pf::shortcode()->exec($content) . "</div>";
    }

    public function tabs($atts, $content = null){
        global $pf_tab_ids;
        $pf_tab_ids = array();

        global $pf_tab_id;
        $pf_tab_id = uniqid() . rand(1, 1000);

        global $pf_tab_index;
        $pf_tab_index = 0;

        if(!empty($atts['value'])){
            $atts['style'] = (!empty($atts['style'])) ? $atts['style'] . ' margin-bottom:10px;' : 'margin-bottom:10px;';
            $nav_tabs      = '<ul class="nav nav-tabs" id="' . $pf_tab_id . '" ' . parse_atts($atts) . '>';
            $tabs          = explode('|', $atts['value']);
            foreach($tabs as $k => $tab){
                $tab_id         = uniqid() . rand(1, 1000);
                $pf_tab_ids[$k] = $tab_id;
                $active         = ($k == 0) ? 'class="active"' : '';
                $nav_tabs .= '<li ' . $active . '><a href="#' . $tab_id . '" data-toggle="tab">' . Pf::shortcode()->exec($tab) . '</a></li>';
            }
            $nav_tabs .= '</ul>';
            $nav_tabs .= '<div class="tab-content">';
            $nav_tabs .= Pf::shortcode()->exec($content);
            $nav_tabs .= '</div>';
        }
        $pf_tab_ids   = array();
        $pf_tab_id    = '';
        $pf_tab_index = 0;

        return $nav_tabs;
    }

    public function tab($atts, $content = null){
        global $pf_tab_ids;
        global $pf_tab_index;
        $active = ($pf_tab_index == 0) ? 'active' : '';
        $tab    = '<div class="tab-pane ' . $active . '" id="' . $pf_tab_ids[$pf_tab_index] . '">';
        $tab .= Pf::shortcode()->exec($content);
        $tab .= '</div>';
        $pf_tab_index++;

        return $tab;
    }

    public function accordion($atts, $content = null){
        global $accordion_id;
        $accordion_id = uniqid() . rand(1, 1000);
        $accordion    = '<div class="panel-group" id="' . $accordion_id . '" ' . parse_atts($atts) . '>';
        $accordion .= Pf::shortcode()->exec($content);
        $accordion .= '</div>';

        return $accordion;
    }

    public function collapse($atts, $content = null){
        global $accordion_id;
        $active      = !empty($atts['active']) ? 1 : 0;
        $collapse_id = uniqid() . rand(1, 100);
        // panel
        $collapse = '<div class="panel panel-default accordion">';
        // Title 
        $collapse .= '<div class="panel-heading">';
        $collapse .= '<h4 class="panel-title">';
        $collapse .= '<a data-toggle="collapse" data-parent="#' . $accordion_id . '" href="#' . $collapse_id . '">';
        $collapse .= Pf::shortcode()->exec((!empty($atts['title'])) ? $atts['title'] : '');
        $collapse .= '</a>';
        $collapse .= '</h4>';
        $collapse .= '</div>';
        // End title

        // Body
        if($active)
            $collapse .= '<div id="' . $collapse_id . '" class="panel-collapse collapse in" style="height: auto;">';
        else
            $collapse .= '<div id="' . $collapse_id . '" class="panel-collapse collapse">';
        $collapse .= '<div class="panel-body">';
        $collapse .= Pf::shortcode()->exec($content);
        $collapse .= '</div>';
        $collapse .= '</div>';
        // End body

        $collapse .= '</div>';
        // End panel

        return $collapse;
    }

    public function moza_slider($atts, $content = null, $tag){
        public_css('moza-slider/css/moza.css');
        public_css('moza-slider/css/skin/default/style.css');

        public_js('moza-slider/assets/jquery.easing.js');
        public_js('moza-slider/assets/jquery.transform2d.js');
        public_js('moza-slider/assets/raphael-min.js');
        public_js('moza-slider/assets/utility.transform.js');
        
        public_js('moza-slider/js/moza-transitions.min.js');
        public_js('moza-slider/js/moza-slider.min.js');

        return '<div ' . parse_atts($atts) . '>' . Pf::shortcode()->exec($content) . '</div>';
    }

    public function moza_slide($atts, $content = null, $tag){

        return '<div ' . parse_atts($atts) . '>' . Pf::shortcode()->exec($content) . '</div>';
    }

    public function general($atts, $content = null, $tag){
        $script = '';
        if(isset($atts['data-toggle'])){
            switch(strtolower(trim($atts['data-toggle']))){
                case 'tooltip':
                    $tooltip_class = 'tooltop-' . uniqid() . rand(1, 1000);
                    if(isset($atts['class'])){
                        $atts['class'] = $atts['class'] . ' ' . $tooltip_class;
                    }else{
                        $atts['class'] = $tooltip_class;
                    }
                    $script = "
            	    <script>
            	    $('.{$tooltip_class}').tooltip();
            	    </script>
            	    ";
                    break;
                case 'popover':
                    $popover_class = 'popover-' . uniqid() . rand(1, 1000);
                    if(isset($atts['class'])){
                        $atts['class'] = $atts['class'] . ' ' . $popover_class;
                    }else{
                        $atts['class'] = $popover_class;
                    }
                    $script = "
        	        <script>
        	        $('.{$popover_class}').popover();
        	        </script>
        	        ";
                    break;
            }
        }

        return '<' . $tag . ' ' . parse_atts($atts) . '>' . Pf::shortcode()->exec($content) . '</' . $tag . '>' . $script;
    }

    public function br($atts, $content = null){

        return '<br ' . parse_atts($atts) . '>';
    }

    public function img($atts, $content = null){
        $src = Pf::shortcode()->exec("{php:url url='" . $atts['src'] . "'}{/php:url}");
        unset($atts['relative']);
        unset($atts['src']);
        return '<img src="' . $src . '" ' . parse_atts($atts) . '>';
    }

    public function alert($atts, $content = null, $tag){
        $atts['class'] = (isset($atts['class'])) ? $atts['class'] : '';
        switch(strtolower(trim($tag))){
            case 'alert-success':
                $atts['class'] = 'alert alert-success ' . $atts['class'];
                break;
            case 'alert-info':
                $atts['class'] = 'alert alert-info ' . $atts['class'];
                break;
            case 'alert-warning':
                $atts['class'] = 'alert alert-warning ' . $atts['class'];
                break;
            case 'alert-danger':
                $atts['class'] = 'alert alert-danger ' . $atts['class'];
                break;
        }

        return '<div ' . parse_atts($atts) . '>' . Pf::shortcode()->exec($content) . '</div>';

    }

    public function youtube_video($atts, $content = null){
        $atts['id']     = (!empty($atts['id'])) ? $atts['id'] : '';
        $atts['width']  = (!empty($atts['width'])) ? $atts['width'] : '600';
        $atts['height'] = (!empty($atts['height'])) ? $atts['height'] : '360';

        return '<div style="max-width:' . $atts['width'] . 'px;max-height:' . $atts['height'] . 'px;"><iframe title="YouTube video player" width="' . $atts['width'] . '" height="' . $atts['height'] . '" src="http://www.youtube.com/embed/' . $atts['id'] . '?wmode=transparent" frameborder="0" allowfullscreen></iframe></div>';
    }

    public function vimeo_video($atts, $content = null){
        $atts['id']     = (!empty($atts['id'])) ? $atts['id'] : '';
        $atts['class']  = (!empty($atts['class'])) ? $atts['class'] : '';
        $atts['width']  = (!empty($atts['width'])) ? $atts['width'] : '600';
        $atts['height'] = (!empty($atts['height'])) ? $atts['height'] : '360';

        return '<div ' . $atts['class'] . ' style="max-width:' . $atts['width'] . 'px;max-height:' . $atts['height'] . 'px;"><iframe src="http://player.vimeo.com/video/' . $atts['id'] . '" width="' . $atts['width'] . '" height="' . $atts['height'] . '" frameborder="0"></iframe></div>';
    }

    public function soundcloud_audio($atts, $content = null){
        $atts['url']       = (!empty($atts['url'])) ? $atts['url'] : '';
        $atts['width']     = (!empty($atts['width'])) ? $atts['width'] : '100%';
        $atts['height']    = (!empty($atts['height'])) ? $atts['height'] : 81;
        $atts['comments']  = (!empty($atts['comments'])) ? $atts['comments'] : 'true';
        $atts['auto_play'] = (!empty($atts['auto_play'])) ? $atts['auto_play'] : 'true';
        $atts['color']     = (!empty($atts['color'])) ? $atts['color'] : 'ff7700';

        if($atts['comments'] == 'yes'){
            $atts['comments'] = 'true';
        }elseif($atts['comments'] == 'no'){
            $atts['comments'] = 'false';
        }

        if($atts['auto_play'] == 'yes'){
            $atts['auto_play'] = 'true';
        }elseif($atts['auto_play'] == 'no'){
            $atts['auto_play'] = 'false';
        }

        if($atts['color']){
            $atts['color'] = str_replace('#', '', $atts['color']);
        }

        return '<iframe width="' . $atts['width'] . '" height="' . $atts['height'] . '" scrolling="no" frameborder="no" src="https://w.soundcloud.com/player/?url=' . urlencode($atts['url']) . '&amp;show_comments=' . $atts['comments'] . '&amp;auto_play=' . $atts['auto_play'] . '&amp;color=' . $atts['color'] . '"></iframe>';
    }

    public function google_map($atts, $content = null){
        public_js('http://maps.google.com/maps/api/js?sensor=false', true);
        public_js('js/jquery.gomap-1.3.2.min.js');

        $atts['address']         = (!empty($atts['address'])) ? $atts['address'] : '';
        $atts['type']            = (!empty($atts['type'])) ? $atts['type'] : 'satellite';
        $atts['width']           = (!empty($atts['width'])) ? $atts['width'] : '100%';
        $atts['height']          = (!empty($atts['height'])) ? $atts['height'] : '300px';
        $atts['zoom']            = (!empty($atts['zoom'])) ? $atts['zoom'] : '14';
        $atts['scrollwheel']     = (!empty($atts['scrollwheel'])) ? $atts['scrollwheel'] : 'true';
        $atts['scale']           = (!empty($atts['scale'])) ? $atts['scale'] : 'true';
        $atts['zoom_pancontrol'] = (!empty($atts['zoom_pancontrol'])) ? $atts['zoom_pancontrol'] : 'true';


        if($atts['scrollwheel'] == 'yes'){
            $atts['scrollwheel'] = 'true';
        }elseif($atts['scrollwheel'] == 'no'){
            $atts['scrollwheel'] = 'false';
        }

        if($atts['scale'] == 'yes'){
            $atts['scale'] = 'true';
        }elseif($atts['scale'] == 'no'){
            $atts['scale'] = 'false';
        }

        if($atts['zoom_pancontrol'] == 'yes'){
            $atts['zoom_pancontrol'] = 'true';
        }elseif($atts['zoom_pancontrol'] == 'no'){
            $atts['zoom_pancontrol'] = 'false';
        }

        $addresses = explode('|', $atts['address']);

        $mk = '';
        $sp = '';
        foreach($addresses as $v){
            $mk .= $sp . "{
                        address: '{$v}',
                        html: {
                            content: '{$v}',
                            popup: true
                        }
                    }";
            $sp = ',';
        }
        $google_map_id = "gmap-" . uniqid() . rand(1, 100);

        $html = '<div id="' . $google_map_id . '" style="width:' . $atts['width'] . ';height:' . $atts['height'] . ';"></div>';
        $html .= "<script type='text/javascript'>
                jQuery(document).ready(function($) {
                    jQuery('#" . $google_map_id . "').goMap({
                        address: '" . $addresses[0] . "',
                        zoom: " . $atts['zoom'] . ",
                        scrollwheel: " . $atts['scrollwheel'] . ",
                        scaleControl: " . $atts['scale'] . ",
                        navigationControl: " . $atts['zoom_pancontrol'] . ",
                        maptype: '" . $atts['type'] . "',
                        markers: [" . $mk . "]
                    });
                });
                </script>";

        return $html;
    }

    public function i_element($atts, $content = null){
        $content = !empty($content) ? Pf::shortcode()->exec($content) : '';
        $class   = !empty($atts['class']) ? "class='" . $atts['class'] . "'" : '';
        return "<i $class>$content</i>";
    }

    /*** Color box ***/
    public function colorbox($atts, $content = null){
        //using: {style:colorbox color='<color>'}<content>{/style:colorbox}
        $color   = !empty($atts['color']) ? $atts['color'] : 'red';
        $content = !empty($content) ? Pf::shortcode()->exec($content) : '';
        $result  = "<div class='servive-block-in servive-block-colored servive-block-" . $color . "'>
                " . $content . "
            </div>";
        return $result;
    }

    /*** Carousel Slider ***/
    public function carousel($atts, $content = null){
        $data = json_decode("[" . Pf::shortcode()->exec($content) . "]", true);
        $id   = !empty($atts['id']) ? $atts['id'] : uniqid('pf-carousel');
        $class = isset($atts['class']) ? $atts['class'] : '';
        if(!empty($data)){
            $result = "<div id='{$id}' class='carousel slide' data-ride='carousel'>
          <div class='carousel-inner {$class}'>";
            foreach($data as $item){
                if(empty($active))
                    $class = 'active';
                else
                    $class = '';
                $text  = empty($item['text']) ? null : '<h4>' . $item['text'] . '</h4>';
                $link  = empty($item['link']) ? null : $item['link'];
                $image = "<img style='margin:auto' alt='{$item['alt']}' src='{$item['src']}'>";
                if($link != null){
                    $image = "<a href='$link'>{$image}</a>";
                    $text  = "<a href='$link'>{$text}</a>";
                }
                $desc    = empty($item['desc']) ? null : $item['desc'];
                $caption = (!empty($text) || !empty($desc)) ? "<div class='carousel-caption'>{$text}<p>{$desc}</p></div>" : '';
                $result .= "<div class='item {$class}'>";
                $result .= $image;
                $result .= $caption;
                $result .= '</div>';
                $active = 1;
            }
            $result .= "</div>
          <a class='carousel-arrow carousel-arrow-prev' href='#{$id}' data-slide='prev'>
            <i class='fa fa-angle-left'></i>
          </a>
          <a class='carousel-arrow carousel-arrow-next' href='#{$id}' data-slide='next'>
            <i class='fa fa-angle-right'></i>
          </a>
        </div>";
        }else
            $result = "";
        return $result;
    }

    public function imgslide($atts, $content = null){
        //using: {slider:img src='<img url>' text= '<text>' link='<url>'}
        if(empty($atts['text'])) $atts['text'] = '';
        if(empty($atts['desc'])) $atts['desc'] = '';
        $atts['link'] = isset($atts['link']) ? $atts['link'] : null;
        $alt          = isset($atts['alt']) ? $atts['alt'] : '';
        $result       = json_encode(array(
            'src'  => $atts['src'],
            'text' => $atts['text'],
            'desc' => $atts['desc'],
            'link' => $atts['link'],
            'alt'  => $alt,
        ));
        return $result;
    }

    /*** Old Table Shortcode ***/
    public function table_old($atts, $content = null, $class){
        $class    = !empty($class) && $class != 'normal' ? $class : "";
        $style    = !empty($atts['style']) ? $atts['style'] : '';
        $contents = !empty($content) ? Pf::shortcode()->exec($content) : '';
        switch($class){
            case 'table-responsive':
                $result = "<div class='table-responsive'><table class='table $class'  style='$style'>$contents</table></div>";
                break;
            default:
                $result = "<table class='table $class'  style='$style'>$contents</table>";
                break;
        }
        return $result;
    }

    public function row_table($atts, $content = null, $class){
//        $class    = !empty($class) && $class != 'normal' ? "class='$class'" : '';
//        $style    = !empty($atts['style']) ? $atts['style'] : '';
//        $addon    = !empty($atts['addon']) ? $atts['addon'] : '';
        $content = !empty($content) ? Pf::shortcode()->exec($content) : '';
        $content = isset($content) ? $content : '';
        $result   = "<tr ".  parse_atts($atts).">{$content}</tr>";
        return $result;
    }

    public function col_table($atts, $content = null, $class){

        $class = (!empty($class) && $class != 'normal') ? "class='$class'" : '';
        $style = !empty($atts['style']) ? $atts['style'] : '';
//        $class    = !empty($atts['class']) ? $atts['class'] : '';
        $contents = !empty($content) ? Pf::shortcode()->exec($content) : '';
        $result   = "<td $class ".parse_atts($atts).">$contents</td>";
        return $result;
    }

    public function head_table($atts, $content = null, $class){
        $class    = !empty($class) && $class != 'normal' ? "class='$class'" : '';
        $style    = !empty($atts['style']) ? $atts['style'] : '';
        $contents = !empty($content) ? Pf::shortcode()->exec($content) : '';
        $result   = "<th $class ".parse_atts($atts).">$contents</th>";
        return $result;
    }
    /*** New Table Shortcode ***/
    public function table($atts, $content = null) {
        $content = !empty($content) ? Pf::shortcode()->exec($content) : '';
        return "<table ".  parse_atts($atts).">$content</table>";
    }
    public function table_row($atts, $content = null) {
        $content = !empty($content) ? Pf::shortcode()->exec($content) : '';
        return "<tr ".  parse_atts($atts).">$content</tr>";
    }
    public function table_col($atts, $content = null) {
        $content = !empty($content) ? Pf::shortcode()->exec($content) : '';
        return "<td ".  parse_atts($atts).">$content</td>";
    }
    public function table_head($atts, $content = null) {
        $content = !empty($content) ? Pf::shortcode()->exec($content) : '';
        return "<th ".  parse_atts($atts).">$content</th>";
    }
    public function jcarouselslider($atts, $content = null){
        public_js('js/jquery.jcarousel.min.js');
        public_js('js/jcarousel.responsive.js');
        $content = !empty($content) ? "[" . Pf::shortcode()->exec($content) . "]" : '[]';
        $array   = json_decode($content, true);
        $list    = '';
        $class = isset($atts['class']) ? $atts['class'] : '';
        $result =   '';
        if(!empty($array)){
            foreach($array as $item){
                $image = "<img src='{$item['src']}' alt='{$item['alt']}' title='{$item['text']}'>";
                $link  = empty($item['link']) ? null : $item['link'];
                if($link != null){
                    $image = "<a href='$link'>{$image}</a>";
                }
                $list .= "<li>{$image}</li>";
            }
            $result .= " <div class='jcarousel-wrapper {$class}'>
                    <div class='jcarousel'>
                        <ul>
                            $list
                        </ul>
                    </div>
                    <a href='#' class='jcarousel-control-prev'>&lsaquo;</a>
                    <a href='#' class='jcarousel-control-next'>&rsaquo;</a>
                </div>";
        }
        return $result;
    }
/*** Border box***/
    public function borderbox($atts, $content=NULL, $class) {
        $class= !empty($class)?$class:'normal';
        $type   =   !empty($atts['type'])?$atts['type']:'solid';
        $color  =   !empty($atts['color'])?$atts['color']:'#72c02c';
        $width  =   !empty($atts['width'])?$atts['width']:'2px';
        $style  =   !empty($atts['style'])?$atts['style']:'';
        $content=   !empty($content)?Pf::shortcode()->exec($content):'';
        $result="<div class='borderbox border-$class-color' style='border-$class-width: $width; border-$class-style: $type ; $style'>
                    <p>$content</p>
                 </div>";
        return $result;
    }

    /*** List ***/
    public function list_ul($atts, $content = null){
        $content = !empty($content) ? Pf::shortcode()->exec($content) : '';
        $style   = !empty($atts['style']) ? $atts['style'] : '';
        $class   = !empty($atts['class']) ? $atts['class'] : '';
        $result  = "<ul class='$class' style='$style'>$content</ul>";
        return $result;
    }

    public function list_ol($atts, $content = null){
        $content = !empty($content) ? Pf::shortcode()->exec($content) : '';
        $style   = !empty($atts['style']) ? $atts['style'] : '';
        $class   = !empty($atts['class']) ? $atts['class'] : '';
        $result  = "<ol class='$class' style='$style'>$content</ol>";
        return $result;
    }

    public function list_li($atts, $content = null){
        $content = !empty($content) ? Pf::shortcode()->exec($content) : '';
        $style   = !empty($atts['style']) ? "style='" . $atts['style'] . "'" : '';
        $result  = "<li $style>$content</li>";
        return $result;
    }

    /***Social Icon***/
    public function social_icon($atts, $content = null, $class){
        $url    = !empty($atts['url']) ? $atts['url'] : '#';
        $css    = !empty($atts['class']) ? $atts['class'] : '';
        $result = "<a href='$url' data-original-title='$class' class='social-icon $css'><img class='margin-bottom-15' src='".RELATIVE_PATH.'/themes/'. get_option('active_theme')."/img/social_icon/$class.png' /></a>";
        return $result;
    }

    /***Pricing table***/
    public function pricing($atts, $content = null, $class){
        $class   = $class == 'hover' ? 'pricing hover-effect' : 'pricing';
        $special = !empty($atts['special']) ? $atts['special'] : '';
        $content = !empty($content) ? Pf::shortcode()->exec($content) : '';
        $result  = "<div class='$class'>";
        $result .= !empty($special) ? "<div class='ribbon'><span>$special</span></div>" : '';
        $result .= "$content</div>";
        return $result;
    }

    public function pricing_head($atts, $content = null){
        $option  = !empty($atts['option']) ? $atts['option'] : 'standard';
        $content = !empty($content) ? Pf::shortcode()->exec($content) : '';
        return "<div class='pricing-head $option'>
                    $content
                </div>";
    }

    public function pricing_content($atts, $content = null){
        $content = !empty($content) ? Pf::shortcode()->exec($content) : '';
        $class   = !empty($atts['class']) ? $atts['class'] : '';
        return "<div class='pricing-content $class'>
                    $content
                </div>";
    }

    public function pricing_footer($atts, $content = null){
        $content = !empty($content) ? Pf::shortcode()->exec($content) : '';
        return "<div class='pricing-footer'>
                    $content
                </div>";
    }

    /*** Thumbnail ***/
    public function thumbnail($atts, $content = null, $class){
        $class           = $class == 'zoom' ? 'thumbnail-mover' : '';
        $thumbnail_style = !empty($atts['thumb_style']) ? 0 : 1;
        if($thumbnail_style){
            $class = "thumbnail-style " . $class;
        }
        $style   = !empty($atts['class']) ? $atts['class'] : '';
        $img     = !empty($atts['img']) ? $atts['img'] : 'data:image/png;base64,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';
        $subject = !empty($atts['subject']) ? $atts['subject'] : '';
        $content = !empty($content) ? Pf::shortcode()->exec($content) : '';
        $result  = "<div class='thumbnails $class'>
                        <div class='thumbnail-img'>
                            <div class='overflow-hidden'>
                                <img class='img-responsive' src='{$img}' alt=''>
                            </div>";
        $result .= "</div>
                    <div class='caption'>
                        <h3> $subject </h3>
                        $content";
        $result .= "</div>
                </div>";
        return $result;
    }

    /*** Tweets ***/
    private function relative_time($secs){
        $second = 1;
        $minute = 60;
        $hour   = 60 * 60;
        $day    = 60 * 60 * 24;
        $week   = 60 * 60 * 24 * 7;
        $month  = 60 * 60 * 24 * 30;
        $year   = 60 * 60 * 24 * 365;
        if($secs <= 0){
            $output = "now";
        }elseif($secs > $second && $secs < $minute){
            $output = round($secs / $second) . " second";
        }elseif($secs >= $minute && $secs < $hour){
            $output = round($secs / $minute) . " minute";
        }elseif($secs >= $hour && $secs < $day){
            $output = round($secs / $hour) . " hour";
        }elseif($secs >= $day && $secs < $week){
            $output = round($secs / $day) . " day";
        }elseif($secs >= $week && $secs < $month){
            $output = round($secs / $week) . " week";
        }elseif($secs >= $month && $secs < $year){
            $output = round($secs / $month) . " month";
        }elseif($secs >= $year && $secs < $year * 10){
            $output = round($secs / $year) . " year";
        }else{
            $output = " more than a decade ago";
        }

        if($output <> "now"){
            $output = (substr($output, 0, 2) <> "1 ") ? $output . "s" : $output;
        }
        return $output;
    }

    public function tweets($atts, $content = null){
        if(!is_dir(ABSPATH . '/tmp/cache/tweets/')){
                mkdir(ABSPATH . '/tmp/cache/tweets/');
                chmod(ABSPATH . '/tmp/cache/tweets/', 0777);
            }
        $screen_name = !empty($atts['twitter']) ? $atts['twitter'] : 'pageflexcms';
        $num_result  = !empty($atts['num']) ? $atts['num'] : 3;
        $once        = "<div class='blog-twitter-inner'>
                                    <i class='icon-twitter'></i>
                                    <a href='https://twitter.com/{{tweet_author}}'>@{{tweet_author}}</a> 
                                    {{content}}
                                    <span>{{time}}</span>
                            </div>";
        require_once ABSPATH . '/themes/aphrodite/tweet/TweetPHP.php';
        $TweetPHP     = new TweetPHP(array('twitter_screen_name' => $screen_name, 'cache_file' => ABSPATH . '/tmp/cache/tweets/twitter.txt', 'cache_file_raw' => ABSPATH . '/tmp/cache/tweets/twitter-array.txt'));
        $tweet_arrays = $TweetPHP->get_tweet_array();
        if($tweet_arrays != array('error')){
            $contents = '';
            for($i = 0; $i < $num_result; $i++){
                if(!empty($tweet_arrays[$i])){
                    $text         = $TweetPHP->autolink($tweet_arrays[$i]['text']);
                    $tweet_author = $tweet_arrays[$i]['user']['screen_name'];
                    $time         = $this->relative_time(time() - strtotime($tweet_arrays[$i]['created_at']));
                    $once_tweet   = $once;
                    $once_tweet   = str_replace('{{tweet_author}}', $tweet_author, $once_tweet);
                    $once_tweet   = str_replace('{{content}}', $text, $once_tweet);
                    $once_tweet   = str_replace('{{time}}', $time, $once_tweet);
                    $contents .= $once_tweet;

                }else
                    break;
            }
            $result = "<div class='blog-twitter'>$contents</div>";
        }else
            $result = __('There is no tweet yet or wrong twitter name', 'aphrodite-theme');
        return $result;
    }

    /*** Ribbon ***/
    public function ribbon($atts, $content = null){
        $text = !empty($text) ? $text : '';
        return "<h1 class='ribbon'><strong class='ribbon-content'>$text</strong></h1>";
    }

    /***  Breadcrumb ***/
    private function get_page_info($url){
        $this->db->select('id,page_title', 'pf_pages', '`page_url`=?', array($url));
        $page_info = $this->db->fetch_assoc_all();
        if(!empty($page_info[0]))
            return $page_info[0];
        else return false;
    }

    private function current_page(){
        $page = $this->get_page_info($_GET['pf_page_url']);
        return $page['page_title'];
    }

    private function get_post_info($id){
        $this->db->select('post_title, post_category', 'pf_posts', 'id=?', array($id));
        $post_info = $this->db->fetch_assoc_all();
        return $post_info[0];
    }
//TuanDV-10/7/14 - Edit shortcode Breadcrumb
    private function build_category($id, $link = 'cat'){
        $this->db->select('category_name,category_parent', 'pf_categories', '`id`=?', array($id));
        $category_info = $this->db->fetch_assoc_all();
        $post_page     = get_configuration('page_lists', 'pf_post');
        $result        = $this->homepage_li;
        if(!isset($category_info[0]['category_parent'])){
            return $result;
        }
        if($category_info[0]['category_parent'] == 0){
            $result .= "<li><a href='" . public_url($post_page . "/" . $link . ":".$id)."'>" . $category_info[0]['category_name'] . "</a></li>";
        }else{
            $result .= $this->build_category($category_info[0]['category_parent'], $link) . "<li><a href='" . public_url($post_page . "/" . $link . ":".$id) ."'>" . $category_info[0]['category_name'] . "</a></li>";
        }
        return $result;
    }

    private function get_gallery_detail($id){
        if($id == 'all'){
            $result = $this->homepage_li . "<li class='active'>" . $this->current_page() . "</li>";
        }else{
            $this->db->select('gallery_name', 'pf_galleries', '`id`=?', array($id));
            $gallery_detail = $this->db->fetch_assoc_all();
            $result         = $this->homepage_li . "<li><a href='" . public_url( $_GET['pf_page_url']) . "'>" . $this->current_page() . "</a></li>"
                . "<li class='active'>" . $gallery_detail[0]['gallery_name'] . "</li>";
        }
        return $result;
    }

    private function get_portfolio_detail($id, $link = 'portfolio'){
        $result = isset($_GET['portfolio-id'])?$this->homepage_li . "<li><a href='" . public_url( $_GET['pf_page_url'] ). "'>" . $this->current_page() . "</a></li>":$this->homepage_li . "<li class='active'>" . $this->current_page() . "</li>";
        if(isset($_GET['portfolio-id'])){
            $this->db->select('portfolio_name,portfolio_category', 'pf_portfolios', '`portfolio_id`=?', array($id));
            $portfolio_detail = $this->db->fetch_assoc_all();
            $this->db->select('category_name', 'pf_portfolio_categories', '`category_id`=?', array($portfolio_detail[0]['portfolio_category']));
            $category_detail = $this->db->fetch_assoc_all();
            $result .= "<li><a href='" . public_url($link . "/portfolio-cat:" . $portfolio_detail[0]['portfolio_category']) . "'>" . $category_detail[0]['category_name'] . "</a></li><li class='active'>" . $portfolio_detail[0]['portfolio_name'] . "</li>";
        }
        return $result;
    }

    public function breadcrumb($atts, $content = null, $class){
        switch($class){
            case 'page':
                $page_url = $_GET['pf_page_url'];
                if($page_url == $this->homepage){
                    $list = "<li class='active'>" . $this->home_info['page_title'] . "</li>";
                }else{
                    $current_info = $this->get_page_info($page_url);
                    $list         = $this->homepage_li . "<li class='active'>" . $current_info['page_title'] . "</li>";
                }
                break;
            case 'post-category':
                $get     = (isset($atts['get']) && !empty($atts['get'])) ? $atts['get'] : 'id';
                $list_id = isset($_GET[$get]) ? $_GET[$get] : null;
                $list    = $this->build_category($list_id);
                break;
            case 'post':
                $get         = !empty($atts['get']) ? $atts['get'] : 'id';
                $get_cat     = !empty($atts['get_cat']) ? $atts['get_cat'] : 'cat';
                $post_detail = $this->get_post_info($_GET[$get]);
                $list        = $this->build_category($post_detail['post_category'], $get_cat) . "<li class='active'>" . $post_detail['post_title'] . "</li>";
                break;
            case 'gallery':
                $id   = !empty($_GET['gallery']) ? $_GET['gallery'] : 'all';
                $list = $this->get_gallery_detail($id);
                break;
            case 'portfolio':
                $id   = !empty($_GET['portfolio-id']) ? $_GET['portfolio-id'] : '1';
                $url  = !empty($_GET['pf_page_url']) ? $_GET['pf_page_url'] : 'portfolio';
                $list = $this->get_portfolio_detail($id, $url);
                break;
            default:
                break;
        }
        $result = "<ol class='breadcrumb'>$list</ol>";
        return $result;
    }

    /** Comment Of HTML **/
    public function comment($content = null){
        return "<!-- {$content} -->";
    }

    public function hr($atts, $content = null){

        return '<hr ' . parse_atts($atts) . '/>';
    }

    public function datetime($atts, $content = null){
        $format = isset($atts['format']) ? $atts['format'] : 'Y';
        $timestamp = isset($atts['timestamp']) ? $atts['timestamp'] : time();
        return date($format, $timestamp);
        return date($format,$timestamp);
    }

    public function title_headline($atts, $content = null){
        $content = !empty($content) ? $content : '';
        $size    = !empty($atts['size']) ? $atts['size'] : 2;
        return "<div class='headline'><h{$size} class='border-color'>$content</h{$size}></div>";
    }

    /*Comment Of Html*/
    public function get_url($atts, $content = null){
        $url      = isset($atts['url']) ? $atts['url'] : '';
        $relative = RELATIVE_PATH;
        if(empty($relative)){
            return site_url() . '/' . $url;
        }
        return site_url() . "{$relative}/{$url}";
    }

    public function code($atts = null, $content = null){
        $linenums = isset($atts['linenums']) ? (int)$atts['linenums'] : 0;
        $class    = '' . isset($atts['class']) ? $atts['class'] : '';
        $js       = '';
        if(isset($atts['highline'])){
            $js = '';
        }else{
            public_js('prettify/prettify.js');
            public_js('prettify/lang-css.js');
        }

        return $js . '
            <div class="highlight ' . $class . '" onload="prettyPrint()"><pre><code class="html prettyprint linenums:' . $linenums . ' languague-css">' . $content . '</code></pre></div>';
    }

    public function pricing2($atts, $content = null){
        $class       = isset($atts['class']) ? $atts['class'] : '';
        $title       = isset($atts['title']) ? $atts['title'] : null;
        $description = isset($atts['description']) ? $atts['description'] : null;
        $result      = "<div class=\"pricing2 pricing hover-effect animated  fadeInDown delay1 {$class}\">";
        $result .= ($title === null) ? null : "<h3 class=\"text-center\">{$title}</h3>";
        $result .= ($description === null) ? null : "<p class=\"text-muted text-center\">{$description}</p>";
        $result .= (empty($content)) ? null : Pf::shortcode()->exec($content);
        $result .= "</div>";
        return $result;
    }

    public function pricing_head2($atts, $content = null){
        $after  = (isset($atts['after'])) ? $atts['after'] : '';
        $before = (isset($atts['before'])) ? $atts['before'] : '';
        return "<div class=\"price\"><span class='after'>{$before}</span>{$content}<span class='before'>{$after}</span></div>";
    }

    public function pricing_content2($atts, $content = null){
        $content = !empty($content) ? Pf::shortcode()->exec($content) : null;
        $class   = !empty($atts['class']) ? $atts['class'] : '';
        return "<div class=\"pricing-text text-center text-muted $class\">{$content}</div>";
    }

    public function pricing_button2($atts, $content = null){
        $class = !empty($atts['class']) ? $atts['class'] : 'btn-default';
        $link  = isset($atts['url']) ? $atts['url'] : '#';
        return "<a class=\"btn btn-block btn-xxl {$class}\" href=\"{$link}\">{$content}</a>";
    }

    public function script($atts, $content = null){
        $script = "";
        $script .= '<script type="text/javascript">';
        $script .= !empty($content) ? $content : '';
        $script .= '</script>';
        return $script;
    }
}

